//Frequency Domain Methods for controller design

// 1- Normalized bandwidth vs Damping factor (second order system)
deff("[a]=f1(b)","a=sqrt(1-2*b^2+sqrt(2-4*b^2+4*b^4))")
b=[0:0.01:0.9];
subplot(311)
fplot2d(b,f1,[1])
xgrid(2)
xtitle(['Normalized bandwidth vs Damping Factor'],'Damping ratio', ' Normalized bandwidth ' );

// 2- Peak overshoot  vs  Resonance Peak  (second order system)
deff("[C]=f2(b)","C=exp((-%pi*b)/sqrt(1-b^2))")
deff("[D]=f3(b)","D=1/(2*b*sqrt(1-b^2))")
b=[0.05:0.01:0.9];
subplot(312)
xset("line style",4);
fplot2d(b,f2,[1])
xset("line style",1);
fplot2d(b,f3,[1])
xgrid(3)
xtitle([' Peak overshoot  vs  Resonance Peak'  ],'Damping ratio', 'Peak Gain, Resonance Gain' );
legends([' Peak Gain';' Resonance Gain'],[[1;4],[1;1]],opt=1);

// 3- Resonant Frequency vs Damping Frequency (Second order system)
deff("[e]=f4(b)","e=sqrt(1-2*b^2)/sqrt(1-b^2)")
b=[0:0.01:0.9];// don't end with 1 bec, division by 0 error
subplot(313)
fplot2d(b,f4,[1])
xgrid(4)
xtitle(['Resonant Frequency vs Damping Frequency'],'Damping ratio', '  Resonant Frequency ' );

